/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfigurationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchDestination
implements ToCopyableBuilder<Builder, CloudWatchDestination> {
    private final List<CloudWatchDimensionConfiguration> dimensionConfigurations;

    private CloudWatchDestination(BuilderImpl builder) {
        this.dimensionConfigurations = builder.dimensionConfigurations;
    }

    public List<CloudWatchDimensionConfiguration> dimensionConfigurations() {
        return this.dimensionConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dimensionConfigurations() == null ? 0 : this.dimensionConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDestination)) {
            return false;
        }
        CloudWatchDestination other = (CloudWatchDestination)obj;
        if (other.dimensionConfigurations() == null ^ this.dimensionConfigurations() == null) {
            return false;
        }
        return other.dimensionConfigurations() == null || other.dimensionConfigurations().equals(this.dimensionConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dimensionConfigurations() != null) {
            sb.append("DimensionConfigurations: ").append(this.dimensionConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionConfigurations": {
                return Optional.of(clazz.cast(this.dimensionConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<CloudWatchDimensionConfiguration> dimensionConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDestination model) {
            this.dimensionConfigurations(model.dimensionConfigurations);
        }

        public final Collection<CloudWatchDimensionConfiguration.Builder> getDimensionConfigurations() {
            return this.dimensionConfigurations != null ? (Collection)this.dimensionConfigurations.stream().map(CloudWatchDimensionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copy(dimensionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(CloudWatchDimensionConfiguration ... dimensionConfigurations) {
            this.dimensionConfigurations(Arrays.asList(dimensionConfigurations));
            return this;
        }

        public final void setDimensionConfigurations(Collection<CloudWatchDimensionConfiguration.BuilderImpl> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copyFromBuilder(dimensionConfigurations);
        }

        public CloudWatchDestination build() {
            return new CloudWatchDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchDestination> {
        public Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> var1);

        public Builder dimensionConfigurations(CloudWatchDimensionConfiguration ... var1);
    }
}

