/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.services.ses.model.BounceType;
import software.amazon.awssdk.services.ses.model.RecipientDsnFields;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BouncedRecipientInfo
implements ToCopyableBuilder<Builder, BouncedRecipientInfo> {
    private final String recipient;
    private final String recipientArn;
    private final String bounceType;
    private final RecipientDsnFields recipientDsnFields;

    private BouncedRecipientInfo(BuilderImpl builder) {
        this.recipient = builder.recipient;
        this.recipientArn = builder.recipientArn;
        this.bounceType = builder.bounceType;
        this.recipientDsnFields = builder.recipientDsnFields;
    }

    public String recipient() {
        return this.recipient;
    }

    public String recipientArn() {
        return this.recipientArn;
    }

    public BounceType bounceType() {
        return BounceType.fromValue(this.bounceType);
    }

    public String bounceTypeString() {
        return this.bounceType;
    }

    public RecipientDsnFields recipientDsnFields() {
        return this.recipientDsnFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recipient() == null ? 0 : this.recipient().hashCode());
        hashCode = 31 * hashCode + (this.recipientArn() == null ? 0 : this.recipientArn().hashCode());
        hashCode = 31 * hashCode + (this.bounceTypeString() == null ? 0 : this.bounceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.recipientDsnFields() == null ? 0 : this.recipientDsnFields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BouncedRecipientInfo)) {
            return false;
        }
        BouncedRecipientInfo other = (BouncedRecipientInfo)obj;
        if (other.recipient() == null ^ this.recipient() == null) {
            return false;
        }
        if (other.recipient() != null && !other.recipient().equals(this.recipient())) {
            return false;
        }
        if (other.recipientArn() == null ^ this.recipientArn() == null) {
            return false;
        }
        if (other.recipientArn() != null && !other.recipientArn().equals(this.recipientArn())) {
            return false;
        }
        if (other.bounceTypeString() == null ^ this.bounceTypeString() == null) {
            return false;
        }
        if (other.bounceTypeString() != null && !other.bounceTypeString().equals(this.bounceTypeString())) {
            return false;
        }
        if (other.recipientDsnFields() == null ^ this.recipientDsnFields() == null) {
            return false;
        }
        return other.recipientDsnFields() == null || other.recipientDsnFields().equals(this.recipientDsnFields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recipient() != null) {
            sb.append("Recipient: ").append(this.recipient()).append(",");
        }
        if (this.recipientArn() != null) {
            sb.append("RecipientArn: ").append(this.recipientArn()).append(",");
        }
        if (this.bounceTypeString() != null) {
            sb.append("BounceType: ").append(this.bounceTypeString()).append(",");
        }
        if (this.recipientDsnFields() != null) {
            sb.append("RecipientDsnFields: ").append(this.recipientDsnFields()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Recipient": {
                return Optional.of(clazz.cast(this.recipient()));
            }
            case "RecipientArn": {
                return Optional.of(clazz.cast(this.recipientArn()));
            }
            case "BounceType": {
                return Optional.of(clazz.cast(this.bounceTypeString()));
            }
            case "RecipientDsnFields": {
                return Optional.of(clazz.cast(this.recipientDsnFields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String recipient;
        private String recipientArn;
        private String bounceType;
        private RecipientDsnFields recipientDsnFields;

        private BuilderImpl() {
        }

        private BuilderImpl(BouncedRecipientInfo model) {
            this.recipient(model.recipient);
            this.recipientArn(model.recipientArn);
            this.bounceType(model.bounceType);
            this.recipientDsnFields(model.recipientDsnFields);
        }

        public final String getRecipient() {
            return this.recipient;
        }

        @Override
        public final Builder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        public final void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        public final String getRecipientArn() {
            return this.recipientArn;
        }

        @Override
        public final Builder recipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
            return this;
        }

        public final void setRecipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
        }

        public final String getBounceType() {
            return this.bounceType;
        }

        @Override
        public final Builder bounceType(String bounceType) {
            this.bounceType = bounceType;
            return this;
        }

        @Override
        public final Builder bounceType(BounceType bounceType) {
            this.bounceType(bounceType.toString());
            return this;
        }

        public final void setBounceType(String bounceType) {
            this.bounceType = bounceType;
        }

        public final RecipientDsnFields.Builder getRecipientDsnFields() {
            return this.recipientDsnFields != null ? this.recipientDsnFields.toBuilder() : null;
        }

        @Override
        public final Builder recipientDsnFields(RecipientDsnFields recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields;
            return this;
        }

        public final void setRecipientDsnFields(RecipientDsnFields.BuilderImpl recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields != null ? recipientDsnFields.build() : null;
        }

        public BouncedRecipientInfo build() {
            return new BouncedRecipientInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BouncedRecipientInfo> {
        public Builder recipient(String var1);

        public Builder recipientArn(String var1);

        public Builder bounceType(String var1);

        public Builder bounceType(BounceType var1);

        public Builder recipientDsnFields(RecipientDsnFields var1);
    }
}

