/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse;

public class VerifyDomainDkimResponseUnmarshaller
implements Unmarshaller<VerifyDomainDkimResponse, StaxUnmarshallerContext> {
    private static final VerifyDomainDkimResponseUnmarshaller INSTANCE = new VerifyDomainDkimResponseUnmarshaller();

    public VerifyDomainDkimResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        VerifyDomainDkimResponse.Builder verifyDomainDkimResponse;
        block5: {
            verifyDomainDkimResponse = VerifyDomainDkimResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            ArrayList<String> dkimTokens = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    verifyDomainDkimResponse.dkimTokens(dkimTokens);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("DkimTokens", targetDepth)) {
                        dkimTokens = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("DkimTokens/member", targetDepth)) continue;
                    dkimTokens.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            verifyDomainDkimResponse.dkimTokens(dkimTokens);
        }
        return (VerifyDomainDkimResponse)((Object)verifyDomainDkimResponse.build());
    }

    public static VerifyDomainDkimResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

