/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReorderReceiptRuleSetRequestMarshaller
implements Marshaller<Request<ReorderReceiptRuleSetRequest>, ReorderReceiptRuleSetRequest> {
    public Request<ReorderReceiptRuleSetRequest> marshall(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) {
        List<String> ruleNamesList;
        if (reorderReceiptRuleSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reorderReceiptRuleSetRequest, "SESClient");
        request.addParameter("Action", "ReorderReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (reorderReceiptRuleSetRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)reorderReceiptRuleSetRequest.ruleSetName()));
        }
        if ((ruleNamesList = reorderReceiptRuleSetRequest.ruleNames()) != null) {
            if (!ruleNamesList.isEmpty()) {
                int ruleNamesListIndex = 1;
                for (String ruleNamesListValue : ruleNamesList) {
                    if (ruleNamesListValue != null) {
                        request.addParameter("RuleNames.member." + ruleNamesListIndex, StringUtils.fromString((String)ruleNamesListValue));
                    }
                    ++ruleNamesListIndex;
                }
            } else {
                request.addParameter("RuleNames", "");
            }
        }
        return request;
    }
}

