/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetIdentityMailFromDomainAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityMailFromDomainAttributesRequest>, GetIdentityMailFromDomainAttributesRequest> {
    public Request<GetIdentityMailFromDomainAttributesRequest> marshall(GetIdentityMailFromDomainAttributesRequest getIdentityMailFromDomainAttributesRequest) {
        if (getIdentityMailFromDomainAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIdentityMailFromDomainAttributesRequest, "SESClient");
        request.addParameter("Action", "GetIdentityMailFromDomainAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> identitiesList = getIdentityMailFromDomainAttributesRequest.identities();
        if (identitiesList != null) {
            if (!identitiesList.isEmpty()) {
                int identitiesListIndex = 1;
                for (String identitiesListValue : identitiesList) {
                    if (identitiesListValue != null) {
                        request.addParameter("Identities.member." + identitiesListIndex, StringUtils.fromString((String)identitiesListValue));
                    }
                    ++identitiesListIndex;
                }
            } else {
                request.addParameter("Identities", "");
            }
        }
        return request;
    }
}

