/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.Destination;

public class DestinationUnmarshaller
implements Unmarshaller<Destination, StaxUnmarshallerContext> {
    private static final DestinationUnmarshaller INSTANCE = new DestinationUnmarshaller();

    public Destination unmarshall(StaxUnmarshallerContext context) throws Exception {
        Destination.Builder destination;
        block9: {
            destination = Destination.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> toAddresses = null;
            ArrayList<String> ccAddresses = null;
            ArrayList<String> bccAddresses = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    destination.toAddresses(toAddresses);
                    destination.ccAddresses(ccAddresses);
                    destination.bccAddresses(bccAddresses);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ToAddresses", targetDepth)) {
                        toAddresses = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("ToAddresses/member", targetDepth)) {
                        toAddresses.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CcAddresses", targetDepth)) {
                        ccAddresses = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("CcAddresses/member", targetDepth)) {
                        ccAddresses.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BccAddresses", targetDepth)) {
                        bccAddresses = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("BccAddresses/member", targetDepth)) continue;
                    bccAddresses.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            destination.toAddresses(toAddresses);
            destination.ccAddresses(ccAddresses);
            destination.bccAddresses(bccAddresses);
        }
        return (Destination)destination.build();
    }

    public static DestinationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

