/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.VerificationTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VerifyDomainDkimResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, VerifyDomainDkimResponse> {
    private final List<String> dkimTokens;

    private VerifyDomainDkimResponse(BuilderImpl builder) {
        this.dkimTokens = builder.dkimTokens;
    }

    public List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dkimTokens() == null ? 0 : this.dkimTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainDkimResponse)) {
            return false;
        }
        VerifyDomainDkimResponse other = (VerifyDomainDkimResponse)((Object)obj);
        if (other.dkimTokens() == null ^ this.dkimTokens() == null) {
            return false;
        }
        return other.dkimTokens() == null || other.dkimTokens().equals(this.dkimTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dkimTokens() != null) {
            sb.append("DkimTokens: ").append(this.dkimTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> dkimTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainDkimResponse model) {
            this.setDkimTokens(model.dkimTokens);
        }

        public final Collection<String> getDkimTokens() {
            return this.dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            this.dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        public VerifyDomainDkimResponse build() {
            return new VerifyDomainDkimResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VerifyDomainDkimResponse> {
        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

