/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateReceiptRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateReceiptRuleRequest> {
    private final String ruleSetName;
    private final ReceiptRule rule;

    private UpdateReceiptRuleRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.rule = builder.rule;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public ReceiptRule rule() {
        return this.rule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleSetName() == null ? 0 : this.ruleSetName().hashCode());
        hashCode = 31 * hashCode + (this.rule() == null ? 0 : this.rule().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReceiptRuleRequest)) {
            return false;
        }
        UpdateReceiptRuleRequest other = (UpdateReceiptRuleRequest)((Object)obj);
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.rule() == null ^ this.rule() == null) {
            return false;
        }
        return other.rule() == null || other.rule().equals(this.rule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.rule() != null) {
            sb.append("Rule: ").append(this.rule()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleSetName;
        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReceiptRuleRequest model) {
            this.setRuleSetName(model.ruleSetName);
            this.setRule(model.rule);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final ReceiptRule getRule() {
            return this.rule;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule rule) {
            this.rule = rule;
        }

        public UpdateReceiptRuleRequest build() {
            return new UpdateReceiptRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder rule(ReceiptRule var1);
    }
}

