/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetIdentityVerificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityVerificationAttributesRequest>, GetIdentityVerificationAttributesRequest> {
    public Request<GetIdentityVerificationAttributesRequest> marshall(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        if (getIdentityVerificationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIdentityVerificationAttributesRequest, "SESClient");
        request.addParameter("Action", "GetIdentityVerificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> identitiesList = getIdentityVerificationAttributesRequest.identities();
        if (identitiesList != null) {
            if (!identitiesList.isEmpty()) {
                int identitiesListIndex = 1;
                for (String identitiesListValue : identitiesList) {
                    if (identitiesListValue != null) {
                        request.addParameter("Identities.member." + identitiesListIndex, StringUtils.fromString((String)identitiesListValue));
                    }
                    ++identitiesListIndex;
                }
            } else {
                request.addParameter("Identities", "");
            }
        }
        return request;
    }
}

