/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.ses.model.IdentityDkimAttributes;
import software.amazon.awssdk.services.ses.transform.IdentityDkimAttributesUnmarshaller;

public class GetIdentityDkimAttributesResponseUnmarshaller
implements Unmarshaller<GetIdentityDkimAttributesResponse, StaxUnmarshallerContext> {
    private static GetIdentityDkimAttributesResponseUnmarshaller INSTANCE;

    public GetIdentityDkimAttributesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetIdentityDkimAttributesResponse.Builder getIdentityDkimAttributesResponse;
        block5: {
            getIdentityDkimAttributesResponse = GetIdentityDkimAttributesResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            HashMap<String, IdentityDkimAttributes> dkimAttributes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    getIdentityDkimAttributesResponse.dkimAttributes(dkimAttributes);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("DkimAttributes/entry", targetDepth)) continue;
                    if (dkimAttributes == null) {
                        dkimAttributes = new HashMap<String, IdentityDkimAttributes>();
                    }
                    Map.Entry<String, IdentityDkimAttributes> entry = DkimAttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    dkimAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            getIdentityDkimAttributesResponse.dkimAttributes(dkimAttributes);
        }
        return (GetIdentityDkimAttributesResponse)((Object)getIdentityDkimAttributesResponse.build());
    }

    public static GetIdentityDkimAttributesResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GetIdentityDkimAttributesResponseUnmarshaller();
        }
        return INSTANCE;
    }

    private static class DkimAttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, IdentityDkimAttributes>, StaxUnmarshallerContext> {
        private static DkimAttributesMapEntryUnmarshaller INSTANCE;

        private DkimAttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, IdentityDkimAttributes> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)IdentityDkimAttributesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static DkimAttributesMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new DkimAttributesMapEntryUnmarshaller();
            }
            return INSTANCE;
        }
    }
}

