/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.BulkEmailDestination;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest;

public class SendBulkTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendBulkTemplatedEmailRequest>, SendBulkTemplatedEmailRequest> {
    public Request<SendBulkTemplatedEmailRequest> marshall(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {
        if (sendBulkTemplatedEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendBulkTemplatedEmailRequest, "SesClient");
        request.addParameter("Action", "SendBulkTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBulkTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.source()));
        }
        if (sendBulkTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.sourceArn()));
        }
        if (sendBulkTemplatedEmailRequest.replyToAddresses().isEmpty() && !(sendBulkTemplatedEmailRequest.replyToAddresses() instanceof SdkAutoConstructList)) {
            request.addParameter("ReplyToAddresses", "");
        } else if (!sendBulkTemplatedEmailRequest.replyToAddresses().isEmpty() && !(sendBulkTemplatedEmailRequest.replyToAddresses() instanceof SdkAutoConstructList)) {
            List<String> replyToAddressesList = sendBulkTemplatedEmailRequest.replyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringConversion.fromString((String)replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendBulkTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.returnPath()));
        }
        if (sendBulkTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.returnPathArn()));
        }
        if (sendBulkTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.configurationSetName()));
        }
        if (sendBulkTemplatedEmailRequest.defaultTags().isEmpty() && !(sendBulkTemplatedEmailRequest.defaultTags() instanceof SdkAutoConstructList)) {
            request.addParameter("DefaultTags", "");
        } else if (!sendBulkTemplatedEmailRequest.defaultTags().isEmpty() && !(sendBulkTemplatedEmailRequest.defaultTags() instanceof SdkAutoConstructList)) {
            List<MessageTag> defaultTagsList = sendBulkTemplatedEmailRequest.defaultTags();
            int defaultTagsListIndex = 1;
            for (MessageTag defaultTagsListValue : defaultTagsList) {
                if (defaultTagsListValue.name() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Name", StringConversion.fromString((String)defaultTagsListValue.name()));
                }
                if (defaultTagsListValue.value() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Value", StringConversion.fromString((String)defaultTagsListValue.value()));
                }
                ++defaultTagsListIndex;
            }
        }
        if (sendBulkTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.template()));
        }
        if (sendBulkTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.templateArn()));
        }
        if (sendBulkTemplatedEmailRequest.defaultTemplateData() != null) {
            request.addParameter("DefaultTemplateData", StringConversion.fromString((String)sendBulkTemplatedEmailRequest.defaultTemplateData()));
        }
        if (sendBulkTemplatedEmailRequest.destinations().isEmpty() && !(sendBulkTemplatedEmailRequest.destinations() instanceof SdkAutoConstructList)) {
            request.addParameter("Destinations", "");
        } else if (!sendBulkTemplatedEmailRequest.destinations().isEmpty() && !(sendBulkTemplatedEmailRequest.destinations() instanceof SdkAutoConstructList)) {
            List<BulkEmailDestination> destinationsList = sendBulkTemplatedEmailRequest.destinations();
            int destinationsListIndex = 1;
            for (BulkEmailDestination destinationsListValue : destinationsList) {
                Destination destination = destinationsListValue.destination();
                if (destination != null) {
                    if (destination.toAddresses().isEmpty() && !(destination.toAddresses() instanceof SdkAutoConstructList)) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses", "");
                    } else if (!destination.toAddresses().isEmpty() && !(destination.toAddresses() instanceof SdkAutoConstructList)) {
                        List<String> toAddressesList = destination.toAddresses();
                        int toAddressesListIndex = 1;
                        for (String toAddressesListValue : toAddressesList) {
                            if (toAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses.member." + toAddressesListIndex, StringConversion.fromString((String)toAddressesListValue));
                            }
                            ++toAddressesListIndex;
                        }
                    }
                    if (destination.ccAddresses().isEmpty() && !(destination.ccAddresses() instanceof SdkAutoConstructList)) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses", "");
                    } else if (!destination.ccAddresses().isEmpty() && !(destination.ccAddresses() instanceof SdkAutoConstructList)) {
                        List<String> ccAddressesList = destination.ccAddresses();
                        int ccAddressesListIndex = 1;
                        for (String ccAddressesListValue : ccAddressesList) {
                            if (ccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses.member." + ccAddressesListIndex, StringConversion.fromString((String)ccAddressesListValue));
                            }
                            ++ccAddressesListIndex;
                        }
                    }
                    if (destination.bccAddresses().isEmpty() && !(destination.bccAddresses() instanceof SdkAutoConstructList)) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses", "");
                    } else if (!destination.bccAddresses().isEmpty() && !(destination.bccAddresses() instanceof SdkAutoConstructList)) {
                        List<String> bccAddressesList = destination.bccAddresses();
                        int bccAddressesListIndex = 1;
                        for (String bccAddressesListValue : bccAddressesList) {
                            if (bccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses.member." + bccAddressesListIndex, StringConversion.fromString((String)bccAddressesListValue));
                            }
                            ++bccAddressesListIndex;
                        }
                    }
                }
                if (destinationsListValue.replacementTags().isEmpty() && !(destinationsListValue.replacementTags() instanceof SdkAutoConstructList)) {
                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags", "");
                } else if (!destinationsListValue.replacementTags().isEmpty() && !(destinationsListValue.replacementTags() instanceof SdkAutoConstructList)) {
                    List<MessageTag> replacementTagsList = destinationsListValue.replacementTags();
                    int replacementTagsListIndex = 1;
                    for (MessageTag replacementTagsListValue : replacementTagsList) {
                        if (replacementTagsListValue.name() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Name", StringConversion.fromString((String)replacementTagsListValue.name()));
                        }
                        if (replacementTagsListValue.value() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Value", StringConversion.fromString((String)replacementTagsListValue.value()));
                        }
                        ++replacementTagsListIndex;
                    }
                }
                if (destinationsListValue.replacementTemplateData() != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTemplateData", StringConversion.fromString((String)destinationsListValue.replacementTemplateData()));
                }
                ++destinationsListIndex;
            }
        }
        return request;
    }
}

