/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest;

public class GetIdentityPoliciesRequestMarshaller
implements Marshaller<Request<GetIdentityPoliciesRequest>, GetIdentityPoliciesRequest> {
    public Request<GetIdentityPoliciesRequest> marshall(GetIdentityPoliciesRequest getIdentityPoliciesRequest) {
        if (getIdentityPoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityPoliciesRequest, "SesClient");
        request.addParameter("Action", "GetIdentityPolicies");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityPoliciesRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)getIdentityPoliciesRequest.identity()));
        }
        if (getIdentityPoliciesRequest.policyNames().isEmpty() && !(getIdentityPoliciesRequest.policyNames() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyNames", "");
        } else if (!getIdentityPoliciesRequest.policyNames().isEmpty() && !(getIdentityPoliciesRequest.policyNames() instanceof SdkAutoConstructList)) {
            List<String> policyNamesList = getIdentityPoliciesRequest.policyNames();
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringConversion.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

