/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;

public class DeleteIdentityRequestMarshaller
implements Marshaller<Request<DeleteIdentityRequest>, DeleteIdentityRequest> {
    public Request<DeleteIdentityRequest> marshall(DeleteIdentityRequest deleteIdentityRequest) {
        if (deleteIdentityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteIdentityRequest, "SesClient");
        request.addParameter("Action", "DeleteIdentity");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIdentityRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)deleteIdentityRequest.identity()));
        }
        return request;
    }
}

