/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest;

public class CreateConfigurationSetRequestMarshaller
implements Marshaller<Request<CreateConfigurationSetRequest>, CreateConfigurationSetRequest> {
    public Request<CreateConfigurationSetRequest> marshall(CreateConfigurationSetRequest createConfigurationSetRequest) {
        if (createConfigurationSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createConfigurationSetRequest, "SesClient");
        request.addParameter("Action", "CreateConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        ConfigurationSet configurationSet = createConfigurationSetRequest.configurationSet();
        if (configurationSet != null && configurationSet.name() != null) {
            request.addParameter("ConfigurationSet.Name", StringConversion.fromString((String)configurationSet.name()));
        }
        return request;
    }
}

