/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationSetEventDestinationRequest
extends SesRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;
    private final EventDestination eventDestination;

    private UpdateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public EventDestination eventDestination() {
        return this.eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDestination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        UpdateConfigurationSetEventDestinationRequest other = (UpdateConfigurationSetEventDestinationRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.eventDestination(), other.eventDestination());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConfigurationSetEventDestinationRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("EventDestination", (Object)this.eventDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "EventDestination": {
                return Optional.ofNullable(clazz.cast(this.eventDestination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private EventDestination eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetEventDestinationRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.eventDestination(model.eventDestination);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final EventDestination.Builder getEventDestination() {
            return this.eventDestination != null ? this.eventDestination.toBuilder() : null;
        }

        @Override
        public final Builder eventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        public final void setEventDestination(EventDestination.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetEventDestinationRequest build() {
            return new UpdateConfigurationSetEventDestinationRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, UpdateConfigurationSetEventDestinationRequest> {
        public Builder configurationSetName(String var1);

        public Builder eventDestination(EventDestination var1);

        default public Builder eventDestination(Consumer<EventDestination.Builder> eventDestination) {
            return this.eventDestination((EventDestination)((EventDestination.Builder)EventDestination.builder().applyMutation(eventDestination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

