/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Action
implements ToCopyableBuilder<Builder, S3Action> {
    private final String topicArn;
    private final String bucketName;
    private final String objectKeyPrefix;
    private final String kmsKeyArn;

    private S3Action(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.bucketName = builder.bucketName;
        this.objectKeyPrefix = builder.objectKeyPrefix;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String objectKeyPrefix() {
        return this.objectKeyPrefix;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.objectKeyPrefix(), other.objectKeyPrefix()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"S3Action").add("TopicArn", (Object)this.topicArn()).add("BucketName", (Object)this.bucketName()).add("ObjectKeyPrefix", (Object)this.objectKeyPrefix()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "ObjectKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.objectKeyPrefix()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String bucketName;
        private String objectKeyPrefix;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            this.topicArn(model.topicArn);
            this.bucketName(model.bucketName);
            this.objectKeyPrefix(model.objectKeyPrefix);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getObjectKeyPrefix() {
            return this.objectKeyPrefix;
        }

        @Override
        public final Builder objectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
            return this;
        }

        public final void setObjectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public S3Action build() {
            return new S3Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Action> {
        public Builder topicArn(String var1);

        public Builder bucketName(String var1);

        public Builder objectKeyPrefix(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

