/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttributeListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSetRequest
extends SesRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationSetRequest> {
    private final String configurationSetName;
    private final List<String> configurationSetAttributeNames;

    private DescribeConfigurationSetRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.configurationSetAttributeNames = builder.configurationSetAttributeNames;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public List<ConfigurationSetAttribute> configurationSetAttributeNames() {
        return TypeConverter.convert(this.configurationSetAttributeNames, ConfigurationSetAttribute::fromValue);
    }

    public List<String> configurationSetAttributeNamesAsStrings() {
        return this.configurationSetAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetAttributeNamesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetRequest)) {
            return false;
        }
        DescribeConfigurationSetRequest other = (DescribeConfigurationSetRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.configurationSetAttributeNamesAsStrings(), other.configurationSetAttributeNamesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationSetRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("ConfigurationSetAttributeNames", this.configurationSetAttributeNamesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "ConfigurationSetAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.configurationSetAttributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private List<String> configurationSetAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.configurationSetAttributeNamesWithStrings(model.configurationSetAttributeNames);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<String> getConfigurationSetAttributeNames() {
            return this.configurationSetAttributeNames;
        }

        @Override
        public final Builder configurationSetAttributeNamesWithStrings(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNamesWithStrings(String ... configurationSetAttributeNames) {
            this.configurationSetAttributeNamesWithStrings(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        @Override
        public final Builder configurationSetAttributeNames(Collection<ConfigurationSetAttribute> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copyEnumToString(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(ConfigurationSetAttribute ... configurationSetAttributeNames) {
            this.configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        public final void setConfigurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationSetRequest build() {
            return new DescribeConfigurationSetRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigurationSetRequest> {
        public Builder configurationSetName(String var1);

        public Builder configurationSetAttributeNamesWithStrings(Collection<String> var1);

        public Builder configurationSetAttributeNamesWithStrings(String ... var1);

        public Builder configurationSetAttributeNames(Collection<ConfigurationSetAttribute> var1);

        public Builder configurationSetAttributeNames(ConfigurationSetAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

