/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;

public class SetIdentityMailFromDomainRequestMarshaller
implements Marshaller<Request<SetIdentityMailFromDomainRequest>, SetIdentityMailFromDomainRequest> {
    public Request<SetIdentityMailFromDomainRequest> marshall(SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) {
        if (setIdentityMailFromDomainRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setIdentityMailFromDomainRequest, "SesClient");
        request.addParameter("Action", "SetIdentityMailFromDomain");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityMailFromDomainRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)setIdentityMailFromDomainRequest.identity()));
        }
        if (setIdentityMailFromDomainRequest.mailFromDomain() != null) {
            request.addParameter("MailFromDomain", StringConversion.fromString((String)setIdentityMailFromDomainRequest.mailFromDomain()));
        }
        if (setIdentityMailFromDomainRequest.behaviorOnMXFailureAsString() != null) {
            request.addParameter("BehaviorOnMXFailure", StringConversion.fromString((String)setIdentityMailFromDomainRequest.behaviorOnMXFailureAsString()));
        }
        return request;
    }
}

