/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;

public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        if (sendRawEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendRawEmailRequest, "SesClient");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendRawEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString((String)sendRawEmailRequest.source()));
        }
        if (sendRawEmailRequest.destinations().isEmpty() && !(sendRawEmailRequest.destinations() instanceof SdkAutoConstructList)) {
            request.addParameter("Destinations", "");
        } else if (!sendRawEmailRequest.destinations().isEmpty() && !(sendRawEmailRequest.destinations() instanceof SdkAutoConstructList)) {
            List<String> destinationsList = sendRawEmailRequest.destinations();
            int destinationsListIndex = 1;
            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex, StringConversion.fromString((String)destinationsListValue));
                }
                ++destinationsListIndex;
            }
        }
        RawMessage rawMessage = sendRawEmailRequest.rawMessage();
        if (rawMessage != null && rawMessage.data() != null) {
            request.addParameter("RawMessage.Data", StringConversion.fromSdkBytes((SdkBytes)rawMessage.data()));
        }
        if (sendRawEmailRequest.fromArn() != null) {
            request.addParameter("FromArn", StringConversion.fromString((String)sendRawEmailRequest.fromArn()));
        }
        if (sendRawEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString((String)sendRawEmailRequest.sourceArn()));
        }
        if (sendRawEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString((String)sendRawEmailRequest.returnPathArn()));
        }
        if (sendRawEmailRequest.tags().isEmpty() && !(sendRawEmailRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!sendRawEmailRequest.tags().isEmpty() && !(sendRawEmailRequest.tags() instanceof SdkAutoConstructList)) {
            List<MessageTag> tagsList = sendRawEmailRequest.tags();
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringConversion.fromString((String)tagsListValue.name()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (sendRawEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)sendRawEmailRequest.configurationSetName()));
        }
        return request;
    }
}

