/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest;

public class GetIdentityDkimAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityDkimAttributesRequest>, GetIdentityDkimAttributesRequest> {
    public Request<GetIdentityDkimAttributesRequest> marshall(GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) {
        if (getIdentityDkimAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityDkimAttributesRequest, "SesClient");
        request.addParameter("Action", "GetIdentityDkimAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityDkimAttributesRequest.identities().isEmpty() && !(getIdentityDkimAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            request.addParameter("Identities", "");
        } else if (!getIdentityDkimAttributesRequest.identities().isEmpty() && !(getIdentityDkimAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            List<String> identitiesList = getIdentityDkimAttributesRequest.identities();
            int identitiesListIndex = 1;
            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex, StringConversion.fromString((String)identitiesListValue));
                }
                ++identitiesListIndex;
            }
        }
        return request;
    }
}

