/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.VerificationStatus;
import software.amazon.awssdk.services.ses.model.VerificationTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityDkimAttributes
implements ToCopyableBuilder<Builder, IdentityDkimAttributes> {
    private final Boolean dkimEnabled;
    private final String dkimVerificationStatus;
    private final List<String> dkimTokens;

    private IdentityDkimAttributes(BuilderImpl builder) {
        this.dkimEnabled = builder.dkimEnabled;
        this.dkimVerificationStatus = builder.dkimVerificationStatus;
        this.dkimTokens = builder.dkimTokens;
    }

    public Boolean dkimEnabled() {
        return this.dkimEnabled;
    }

    public VerificationStatus dkimVerificationStatus() {
        return VerificationStatus.fromValue(this.dkimVerificationStatus);
    }

    public String dkimVerificationStatusAsString() {
        return this.dkimVerificationStatus;
    }

    public List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimVerificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDkimAttributes)) {
            return false;
        }
        IdentityDkimAttributes other = (IdentityDkimAttributes)obj;
        return Objects.equals(this.dkimEnabled(), other.dkimEnabled()) && Objects.equals(this.dkimVerificationStatusAsString(), other.dkimVerificationStatusAsString()) && Objects.equals(this.dkimTokens(), other.dkimTokens());
    }

    public String toString() {
        return ToString.builder((String)"IdentityDkimAttributes").add("DkimEnabled", (Object)this.dkimEnabled()).add("DkimVerificationStatus", (Object)this.dkimVerificationStatusAsString()).add("DkimTokens", this.dkimTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimEnabled": {
                return Optional.ofNullable(clazz.cast(this.dkimEnabled()));
            }
            case "DkimVerificationStatus": {
                return Optional.ofNullable(clazz.cast(this.dkimVerificationStatusAsString()));
            }
            case "DkimTokens": {
                return Optional.ofNullable(clazz.cast(this.dkimTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean dkimEnabled;
        private String dkimVerificationStatus;
        private List<String> dkimTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDkimAttributes model) {
            this.dkimEnabled(model.dkimEnabled);
            this.dkimVerificationStatus(model.dkimVerificationStatus);
            this.dkimTokens(model.dkimTokens);
        }

        public final Boolean getDkimEnabled() {
            return this.dkimEnabled;
        }

        @Override
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        public final String getDkimVerificationStatus() {
            return this.dkimVerificationStatus;
        }

        @Override
        public final Builder dkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
            return this;
        }

        @Override
        public final Builder dkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus.toString());
            return this;
        }

        public final void setDkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
        }

        public final Collection<String> getDkimTokens() {
            return this.dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            this.dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        public IdentityDkimAttributes build() {
            return new IdentityDkimAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityDkimAttributes> {
        public Builder dkimEnabled(Boolean var1);

        public Builder dkimVerificationStatus(String var1);

        public Builder dkimVerificationStatus(VerificationStatus var1);

        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

