/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes;

public class IdentityNotificationAttributesUnmarshaller
implements Unmarshaller<IdentityNotificationAttributes, StaxUnmarshallerContext> {
    private static final IdentityNotificationAttributesUnmarshaller INSTANCE = new IdentityNotificationAttributesUnmarshaller();

    public IdentityNotificationAttributes unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IdentityNotificationAttributes.Builder identityNotificationAttributes = IdentityNotificationAttributes.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("BounceTopic", targetDepth)) {
                    identityNotificationAttributes.bounceTopic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ComplaintTopic", targetDepth)) {
                    identityNotificationAttributes.complaintTopic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeliveryTopic", targetDepth)) {
                    identityNotificationAttributes.deliveryTopic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ForwardingEnabled", targetDepth)) {
                    identityNotificationAttributes.forwardingEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HeadersInBounceNotificationsEnabled", targetDepth)) {
                    identityNotificationAttributes.headersInBounceNotificationsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HeadersInComplaintNotificationsEnabled", targetDepth)) {
                    identityNotificationAttributes.headersInComplaintNotificationsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HeadersInDeliveryNotificationsEnabled", targetDepth)) continue;
                identityNotificationAttributes.headersInDeliveryNotificationsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IdentityNotificationAttributes)identityNotificationAttributes.build();
    }

    public static IdentityNotificationAttributesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

