/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.ReceiptFilter;
import software.amazon.awssdk.services.ses.model.ReceiptIpFilter;

public class CreateReceiptFilterRequestMarshaller
implements Marshaller<Request<CreateReceiptFilterRequest>, CreateReceiptFilterRequest> {
    public Request<CreateReceiptFilterRequest> marshall(CreateReceiptFilterRequest createReceiptFilterRequest) {
        if (createReceiptFilterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createReceiptFilterRequest, "SESClient");
        request.addParameter("Action", "CreateReceiptFilter");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        ReceiptFilter filter = createReceiptFilterRequest.filter();
        if (filter != null) {
            ReceiptIpFilter ipFilter;
            if (filter.name() != null) {
                request.addParameter("Filter.Name", StringUtils.fromString((String)filter.name()));
            }
            if ((ipFilter = filter.ipFilter()) != null) {
                if (ipFilter.policyAsString() != null) {
                    request.addParameter("Filter.IpFilter.Policy", StringUtils.fromString((String)ipFilter.policyAsString()));
                }
                if (ipFilter.cidr() != null) {
                    request.addParameter("Filter.IpFilter.Cidr", StringUtils.fromString((String)ipFilter.cidr()));
                }
            }
        }
        return request;
    }
}

