/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptIpFilter
implements ToCopyableBuilder<Builder, ReceiptIpFilter> {
    private final String policy;
    private final String cidr;

    private ReceiptIpFilter(BuilderImpl builder) {
        this.policy = builder.policy;
        this.cidr = builder.cidr;
    }

    public ReceiptFilterPolicy policy() {
        return ReceiptFilterPolicy.fromValue(this.policy);
    }

    public String policyAsString() {
        return this.policy;
    }

    public String cidr() {
        return this.cidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptIpFilter)) {
            return false;
        }
        ReceiptIpFilter other = (ReceiptIpFilter)obj;
        return Objects.equals(this.policyAsString(), other.policyAsString()) && Objects.equals(this.cidr(), other.cidr());
    }

    public String toString() {
        return ToString.builder((String)"ReceiptIpFilter").add("Policy", (Object)this.policyAsString()).add("Cidr", (Object)this.cidr()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.of(clazz.cast(this.policyAsString()));
            }
            case "Cidr": {
                return Optional.of(clazz.cast(this.cidr()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policy;
        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptIpFilter model) {
            this.policy(model.policy);
            this.cidr(model.cidr);
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder policy(ReceiptFilterPolicy policy) {
            this.policy(policy.toString());
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getCidr() {
            return this.cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public ReceiptIpFilter build() {
            return new ReceiptIpFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptIpFilter> {
        public Builder policy(String var1);

        public Builder policy(ReceiptFilterPolicy var1);

        public Builder cidr(String var1);
    }
}

