/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.util.StringUtils;

public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        SdkInternalList tagsList;
        SdkInternalList replyToAddressesList;
        Message message;
        Destination destination;
        if (sendEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendEmailRequest, "SESClient");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendEmailRequest.source()));
        }
        if ((destination = sendEmailRequest.destination()) != null) {
            SdkInternalList bccAddressesList;
            SdkInternalList ccAddressesList;
            SdkInternalList toAddressesList = (SdkInternalList)destination.toAddresses();
            if (!toAddressesList.isEmpty() || !toAddressesList.isAutoConstruct()) {
                int toAddressesListIndex = 1;
                for (Object toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (!(ccAddressesList = (SdkInternalList)destination.ccAddresses()).isEmpty() || !ccAddressesList.isAutoConstruct()) {
                int ccAddressesListIndex = 1;
                for (Object ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString((String)ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (!(bccAddressesList = (SdkInternalList)destination.bccAddresses()).isEmpty() || !bccAddressesList.isAutoConstruct()) {
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString((String)bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if ((message = sendEmailRequest.message()) != null) {
            Body body;
            Content subject = message.subject();
            if (subject != null) {
                if (subject.data() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString((String)subject.data()));
                }
                if (subject.charset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString((String)subject.charset()));
                }
            }
            if ((body = message.body()) != null) {
                Content html;
                Content text = body.text();
                if (text != null) {
                    if (text.data() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString((String)text.data()));
                    }
                    if (text.charset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString((String)text.charset()));
                    }
                }
                if ((html = body.html()) != null) {
                    if (html.data() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString((String)html.data()));
                    }
                    if (html.charset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString((String)html.charset()));
                    }
                }
            }
        }
        if (!(replyToAddressesList = (SdkInternalList)sendEmailRequest.replyToAddresses()).isEmpty() || !replyToAddressesList.isAutoConstruct()) {
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString((String)sendEmailRequest.returnPath()));
        }
        if (sendEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendEmailRequest.sourceArn()));
        }
        if (sendEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendEmailRequest.returnPathArn()));
        }
        if (!(tagsList = (SdkInternalList)sendEmailRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString((String)tagsListValue.name()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (sendEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendEmailRequest.configurationSetName()));
        }
        return request;
    }
}

