/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.transform.ReceiptActionUnmarshaller;

public class ReceiptRuleUnmarshaller
implements Unmarshaller<ReceiptRule, StaxUnmarshallerContext> {
    private static ReceiptRuleUnmarshaller INSTANCE;

    public ReceiptRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReceiptRule.Builder receiptRule = ReceiptRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    receiptRule.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    receiptRule.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TlsPolicy", targetDepth)) {
                    receiptRule.tlsPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Recipients", targetDepth)) {
                    receiptRule.recipients(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Recipients/member", targetDepth)) {
                    receiptRule.recipients(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Actions", targetDepth)) {
                    receiptRule.actions(new ArrayList<ReceiptAction>());
                    continue;
                }
                if (context.testExpression("Actions/member", targetDepth)) {
                    receiptRule.actions(ReceiptActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ScanEnabled", targetDepth)) continue;
                receiptRule.scanEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReceiptRule)receiptRule.build();
    }

    public static ReceiptRuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReceiptRuleUnmarshaller();
        }
        return INSTANCE;
    }
}

