/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.MessageDsn;
import software.amazon.awssdk.services.ses.transform.ExtensionFieldUnmarshaller;

public class MessageDsnUnmarshaller
implements Unmarshaller<MessageDsn, StaxUnmarshallerContext> {
    private static MessageDsnUnmarshaller INSTANCE;

    public MessageDsn unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MessageDsn.Builder messageDsn = MessageDsn.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ReportingMta", targetDepth)) {
                    messageDsn.reportingMta(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ArrivalDate", targetDepth)) {
                    messageDsn.arrivalDate(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExtensionFields", targetDepth)) {
                    messageDsn.extensionFields(new ArrayList<ExtensionField>());
                    continue;
                }
                if (!context.testExpression("ExtensionFields/member", targetDepth)) continue;
                messageDsn.extensionFields(ExtensionFieldUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MessageDsn)messageDsn.build();
    }

    public static MessageDsnUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MessageDsnUnmarshaller();
        }
        return INSTANCE;
    }
}

