/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;

public class ListIdentitiesResponseUnmarshaller
implements Unmarshaller<ListIdentitiesResponse, StaxUnmarshallerContext> {
    private static ListIdentitiesResponseUnmarshaller INSTANCE;

    public ListIdentitiesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ListIdentitiesResponse.Builder listIdentitiesResponse = ListIdentitiesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Identities", targetDepth)) {
                    listIdentitiesResponse.identities(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Identities/member", targetDepth)) {
                    listIdentitiesResponse.identities(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NextToken", targetDepth)) continue;
                listIdentitiesResponse.nextToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ListIdentitiesResponse)((Object)listIdentitiesResponse.build());
    }

    public static ListIdentitiesResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ListIdentitiesResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

