/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateConfigurationSetRequestMarshaller
implements Marshaller<Request<CreateConfigurationSetRequest>, CreateConfigurationSetRequest> {
    public Request<CreateConfigurationSetRequest> marshall(CreateConfigurationSetRequest createConfigurationSetRequest) {
        if (createConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConfigurationSetRequest, "SESClient");
        request.addParameter("Action", "CreateConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        ConfigurationSet configurationSet = createConfigurationSetRequest.configurationSet();
        if (configurationSet != null && configurationSet.name() != null) {
            request.addParameter("ConfigurationSet.Name", StringUtils.fromString((String)configurationSet.name()));
        }
        return request;
    }
}

