/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;

public class ConfigurationSetUnmarshaller
implements Unmarshaller<ConfigurationSet, StaxUnmarshallerContext> {
    private static ConfigurationSetUnmarshaller INSTANCE;

    public ConfigurationSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ConfigurationSet.Builder configurationSet = ConfigurationSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Name", targetDepth)) continue;
                configurationSet.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ConfigurationSet)configurationSet.build();
    }

    public static ConfigurationSetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationSetUnmarshaller();
        }
        return INSTANCE;
    }
}

