/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.transform.CloudWatchDimensionConfigurationUnmarshaller;

public class CloudWatchDestinationUnmarshaller
implements Unmarshaller<CloudWatchDestination, StaxUnmarshallerContext> {
    private static CloudWatchDestinationUnmarshaller INSTANCE;

    public CloudWatchDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CloudWatchDestination.Builder cloudWatchDestination = CloudWatchDestination.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DimensionConfigurations", targetDepth)) {
                    cloudWatchDestination.dimensionConfigurations(new ArrayList<CloudWatchDimensionConfiguration>());
                    continue;
                }
                if (!context.testExpression("DimensionConfigurations/member", targetDepth)) continue;
                cloudWatchDestination.dimensionConfigurations(CloudWatchDimensionConfigurationUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CloudWatchDestination)cloudWatchDestination.build();
    }

    public static CloudWatchDestinationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudWatchDestinationUnmarshaller();
        }
        return INSTANCE;
    }
}

