/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Action
implements ToCopyableBuilder<Builder, S3Action> {
    private final String topicArn;
    private final String bucketName;
    private final String objectKeyPrefix;
    private final String kmsKeyArn;

    private S3Action(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.bucketName = builder.bucketName;
        this.objectKeyPrefix = builder.objectKeyPrefix;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String objectKeyPrefix() {
        return this.objectKeyPrefix;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.bucketName() == null ? 0 : this.bucketName().hashCode());
        hashCode = 31 * hashCode + (this.objectKeyPrefix() == null ? 0 : this.objectKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyArn() == null ? 0 : this.kmsKeyArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.bucketName() == null ^ this.bucketName() == null) {
            return false;
        }
        if (other.bucketName() != null && !other.bucketName().equals(this.bucketName())) {
            return false;
        }
        if (other.objectKeyPrefix() == null ^ this.objectKeyPrefix() == null) {
            return false;
        }
        if (other.objectKeyPrefix() != null && !other.objectKeyPrefix().equals(this.objectKeyPrefix())) {
            return false;
        }
        if (other.kmsKeyArn() == null ^ this.kmsKeyArn() == null) {
            return false;
        }
        return other.kmsKeyArn() == null || other.kmsKeyArn().equals(this.kmsKeyArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.bucketName() != null) {
            sb.append("BucketName: ").append(this.bucketName()).append(",");
        }
        if (this.objectKeyPrefix() != null) {
            sb.append("ObjectKeyPrefix: ").append(this.objectKeyPrefix()).append(",");
        }
        if (this.kmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.kmsKeyArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String bucketName;
        private String objectKeyPrefix;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            this.setTopicArn(model.topicArn);
            this.setBucketName(model.bucketName);
            this.setObjectKeyPrefix(model.objectKeyPrefix);
            this.setKmsKeyArn(model.kmsKeyArn);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getObjectKeyPrefix() {
            return this.objectKeyPrefix;
        }

        @Override
        public final Builder objectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
            return this;
        }

        public final void setObjectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public S3Action build() {
            return new S3Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Action> {
        public Builder topicArn(String var1);

        public Builder bucketName(String var1);

        public Builder objectKeyPrefix(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

