/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptActionsListCopier;
import software.amazon.awssdk.services.ses.model.RecipientsListCopier;
import software.amazon.awssdk.services.ses.model.TlsPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptRule
implements ToCopyableBuilder<Builder, ReceiptRule> {
    private final String name;
    private final Boolean enabled;
    private final String tlsPolicy;
    private final List<String> recipients;
    private final List<ReceiptAction> actions;
    private final Boolean scanEnabled;

    private ReceiptRule(BuilderImpl builder) {
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.tlsPolicy = builder.tlsPolicy;
        this.recipients = builder.recipients;
        this.actions = builder.actions;
        this.scanEnabled = builder.scanEnabled;
    }

    public String name() {
        return this.name;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String tlsPolicy() {
        return this.tlsPolicy;
    }

    public List<String> recipients() {
        return this.recipients;
    }

    public List<ReceiptAction> actions() {
        return this.actions;
    }

    public Boolean scanEnabled() {
        return this.scanEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.tlsPolicy() == null ? 0 : this.tlsPolicy().hashCode());
        hashCode = 31 * hashCode + (this.recipients() == null ? 0 : this.recipients().hashCode());
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        hashCode = 31 * hashCode + (this.scanEnabled() == null ? 0 : this.scanEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptRule)) {
            return false;
        }
        ReceiptRule other = (ReceiptRule)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.tlsPolicy() == null ^ this.tlsPolicy() == null) {
            return false;
        }
        if (other.tlsPolicy() != null && !other.tlsPolicy().equals(this.tlsPolicy())) {
            return false;
        }
        if (other.recipients() == null ^ this.recipients() == null) {
            return false;
        }
        if (other.recipients() != null && !other.recipients().equals(this.recipients())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        if (other.actions() != null && !other.actions().equals(this.actions())) {
            return false;
        }
        if (other.scanEnabled() == null ^ this.scanEnabled() == null) {
            return false;
        }
        return other.scanEnabled() == null || other.scanEnabled().equals(this.scanEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.tlsPolicy() != null) {
            sb.append("TlsPolicy: ").append(this.tlsPolicy()).append(",");
        }
        if (this.recipients() != null) {
            sb.append("Recipients: ").append(this.recipients()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        if (this.scanEnabled() != null) {
            sb.append("ScanEnabled: ").append(this.scanEnabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean enabled;
        private String tlsPolicy;
        private List<String> recipients = new SdkInternalList();
        private List<ReceiptAction> actions = new SdkInternalList();
        private Boolean scanEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptRule model) {
            this.setName(model.name);
            this.setEnabled(model.enabled);
            this.setTlsPolicy(model.tlsPolicy);
            this.setRecipients(model.recipients);
            this.setActions(model.actions);
            this.setScanEnabled(model.scanEnabled);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getTlsPolicy() {
            return this.tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy.toString());
            return this;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        public final void setTlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy.toString());
        }

        public final Collection<String> getRecipients() {
            return this.recipients;
        }

        @Override
        public final Builder recipients(Collection<String> recipients) {
            this.recipients = RecipientsListCopier.copy(recipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(String ... recipients) {
            if (this.recipients == null) {
                this.recipients = new SdkInternalList(recipients.length);
            }
            for (String e : recipients) {
                this.recipients.add(e);
            }
            return this;
        }

        public final void setRecipients(Collection<String> recipients) {
            this.recipients = RecipientsListCopier.copy(recipients);
        }

        @SafeVarargs
        public final void setRecipients(String ... recipients) {
            if (this.recipients == null) {
                this.recipients = new SdkInternalList(recipients.length);
            }
            for (String e : recipients) {
                this.recipients.add(e);
            }
        }

        public final Collection<ReceiptAction> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<ReceiptAction> actions) {
            this.actions = ReceiptActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ReceiptAction ... actions) {
            if (this.actions == null) {
                this.actions = new SdkInternalList(actions.length);
            }
            for (ReceiptAction e : actions) {
                this.actions.add(e);
            }
            return this;
        }

        public final void setActions(Collection<ReceiptAction> actions) {
            this.actions = ReceiptActionsListCopier.copy(actions);
        }

        @SafeVarargs
        public final void setActions(ReceiptAction ... actions) {
            if (this.actions == null) {
                this.actions = new SdkInternalList(actions.length);
            }
            for (ReceiptAction e : actions) {
                this.actions.add(e);
            }
        }

        public final Boolean getScanEnabled() {
            return this.scanEnabled;
        }

        @Override
        public final Builder scanEnabled(Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
            return this;
        }

        public final void setScanEnabled(Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
        }

        public ReceiptRule build() {
            return new ReceiptRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptRule> {
        public Builder name(String var1);

        public Builder enabled(Boolean var1);

        public Builder tlsPolicy(String var1);

        public Builder tlsPolicy(TlsPolicy var1);

        public Builder recipients(Collection<String> var1);

        public Builder recipients(String ... var1);

        public Builder actions(Collection<ReceiptAction> var1);

        public Builder actions(ReceiptAction ... var1);

        public Builder scanEnabled(Boolean var1);
    }
}

