/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Destination
implements ToCopyableBuilder<Builder, Destination> {
    private final List<String> toAddresses;
    private final List<String> ccAddresses;
    private final List<String> bccAddresses;

    private Destination(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
        this.bccAddresses = builder.bccAddresses;
    }

    public List<String> toAddresses() {
        return this.toAddresses;
    }

    public List<String> ccAddresses() {
        return this.ccAddresses;
    }

    public List<String> bccAddresses() {
        return this.bccAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.toAddresses() == null ? 0 : this.toAddresses().hashCode());
        hashCode = 31 * hashCode + (this.ccAddresses() == null ? 0 : this.ccAddresses().hashCode());
        hashCode = 31 * hashCode + (this.bccAddresses() == null ? 0 : this.bccAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        if (other.toAddresses() == null ^ this.toAddresses() == null) {
            return false;
        }
        if (other.toAddresses() != null && !other.toAddresses().equals(this.toAddresses())) {
            return false;
        }
        if (other.ccAddresses() == null ^ this.ccAddresses() == null) {
            return false;
        }
        if (other.ccAddresses() != null && !other.ccAddresses().equals(this.ccAddresses())) {
            return false;
        }
        if (other.bccAddresses() == null ^ this.bccAddresses() == null) {
            return false;
        }
        return other.bccAddresses() == null || other.bccAddresses().equals(this.bccAddresses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.toAddresses() != null) {
            sb.append("ToAddresses: ").append(this.toAddresses()).append(",");
        }
        if (this.ccAddresses() != null) {
            sb.append("CcAddresses: ").append(this.ccAddresses()).append(",");
        }
        if (this.bccAddresses() != null) {
            sb.append("BccAddresses: ").append(this.bccAddresses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> toAddresses = new SdkInternalList();
        private List<String> ccAddresses = new SdkInternalList();
        private List<String> bccAddresses = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.setToAddresses(model.toAddresses);
            this.setCcAddresses(model.ccAddresses);
            this.setBccAddresses(model.bccAddresses);
        }

        public final Collection<String> getToAddresses() {
            return this.toAddresses;
        }

        @Override
        public final Builder toAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(String ... toAddresses) {
            if (this.toAddresses == null) {
                this.toAddresses = new SdkInternalList(toAddresses.length);
            }
            for (String e : toAddresses) {
                this.toAddresses.add(e);
            }
            return this;
        }

        public final void setToAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
        }

        @SafeVarargs
        public final void setToAddresses(String ... toAddresses) {
            if (this.toAddresses == null) {
                this.toAddresses = new SdkInternalList(toAddresses.length);
            }
            for (String e : toAddresses) {
                this.toAddresses.add(e);
            }
        }

        public final Collection<String> getCcAddresses() {
            return this.ccAddresses;
        }

        @Override
        public final Builder ccAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(String ... ccAddresses) {
            if (this.ccAddresses == null) {
                this.ccAddresses = new SdkInternalList(ccAddresses.length);
            }
            for (String e : ccAddresses) {
                this.ccAddresses.add(e);
            }
            return this;
        }

        public final void setCcAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
        }

        @SafeVarargs
        public final void setCcAddresses(String ... ccAddresses) {
            if (this.ccAddresses == null) {
                this.ccAddresses = new SdkInternalList(ccAddresses.length);
            }
            for (String e : ccAddresses) {
                this.ccAddresses.add(e);
            }
        }

        public final Collection<String> getBccAddresses() {
            return this.bccAddresses;
        }

        @Override
        public final Builder bccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bccAddresses(String ... bccAddresses) {
            if (this.bccAddresses == null) {
                this.bccAddresses = new SdkInternalList(bccAddresses.length);
            }
            for (String e : bccAddresses) {
                this.bccAddresses.add(e);
            }
            return this;
        }

        public final void setBccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
        }

        @SafeVarargs
        public final void setBccAddresses(String ... bccAddresses) {
            if (this.bccAddresses == null) {
                this.bccAddresses = new SdkInternalList(bccAddresses.length);
            }
            for (String e : bccAddresses) {
                this.bccAddresses.add(e);
            }
        }

        public Destination build() {
            return new Destination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Destination> {
        public Builder toAddresses(Collection<String> var1);

        public Builder toAddresses(String ... var1);

        public Builder ccAddresses(Collection<String> var1);

        public Builder ccAddresses(String ... var1);

        public Builder bccAddresses(Collection<String> var1);

        public Builder bccAddresses(String ... var1);
    }
}

