/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RequestStatus {
    PENDING("PENDING"),
    CASE_OPENED("CASE_OPENED"),
    APPROVED("APPROVED"),
    DENIED("DENIED"),
    CASE_CLOSED("CASE_CLOSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RequestStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RequestStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RequestStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RequestStatus> knownValues() {
        return Stream.of(RequestStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

