/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutServiceQuotaIncreaseRequestIntoTemplateRequest
extends ServiceQuotasRequest
implements ToCopyableBuilder<Builder, PutServiceQuotaIncreaseRequestIntoTemplateRequest> {
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest::quotaCode)).setter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest::serviceCode)).setter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest::awsRegion)).setter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.getter(PutServiceQuotaIncreaseRequestIntoTemplateRequest::desiredValue)).setter(PutServiceQuotaIncreaseRequestIntoTemplateRequest.setter(Builder::desiredValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_CODE_FIELD, SERVICE_CODE_FIELD, AWS_REGION_FIELD, DESIRED_VALUE_FIELD));
    private final String quotaCode;
    private final String serviceCode;
    private final String awsRegion;
    private final Double desiredValue;

    private PutServiceQuotaIncreaseRequestIntoTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.quotaCode = builder.quotaCode;
        this.serviceCode = builder.serviceCode;
        this.awsRegion = builder.awsRegion;
        this.desiredValue = builder.desiredValue;
    }

    public String quotaCode() {
        return this.quotaCode;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public Double desiredValue() {
        return this.desiredValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutServiceQuotaIncreaseRequestIntoTemplateRequest)) {
            return false;
        }
        PutServiceQuotaIncreaseRequestIntoTemplateRequest other = (PutServiceQuotaIncreaseRequestIntoTemplateRequest)((Object)obj);
        return Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.desiredValue(), other.desiredValue());
    }

    public String toString() {
        return ToString.builder((String)"PutServiceQuotaIncreaseRequestIntoTemplateRequest").add("QuotaCode", (Object)this.quotaCode()).add("ServiceCode", (Object)this.serviceCode()).add("AwsRegion", (Object)this.awsRegion()).add("DesiredValue", (Object)this.desiredValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "DesiredValue": {
                return Optional.ofNullable(clazz.cast(this.desiredValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutServiceQuotaIncreaseRequestIntoTemplateRequest, T> g) {
        return obj -> g.apply((PutServiceQuotaIncreaseRequestIntoTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasRequest.BuilderImpl
    implements Builder {
        private String quotaCode;
        private String serviceCode;
        private String awsRegion;
        private Double desiredValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PutServiceQuotaIncreaseRequestIntoTemplateRequest model) {
            super(model);
            this.quotaCode(model.quotaCode);
            this.serviceCode(model.serviceCode);
            this.awsRegion(model.awsRegion);
            this.desiredValue(model.desiredValue);
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final Double getDesiredValue() {
            return this.desiredValue;
        }

        @Override
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutServiceQuotaIncreaseRequestIntoTemplateRequest build() {
            return new PutServiceQuotaIncreaseRequestIntoTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceQuotasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutServiceQuotaIncreaseRequestIntoTemplateRequest> {
        public Builder quotaCode(String var1);

        public Builder serviceCode(String var1);

        public Builder awsRegion(String var1);

        public Builder desiredValue(Double var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

