/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum;
import software.amazon.awssdk.services.servicequotas.model.QuotaContextInfo;
import software.amazon.awssdk.services.servicequotas.model.RequestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestedServiceQuotaChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestedServiceQuotaChange> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::id)).setter(RequestedServiceQuotaChange.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaseId").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::caseId)).setter(RequestedServiceQuotaChange.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseId").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::serviceCode)).setter(RequestedServiceQuotaChange.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::serviceName)).setter(RequestedServiceQuotaChange.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::quotaCode)).setter(RequestedServiceQuotaChange.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaName").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::quotaName)).setter(RequestedServiceQuotaChange.setter(Builder::quotaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()}).build();
    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DesiredValue").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::desiredValue)).setter(RequestedServiceQuotaChange.setter(Builder::desiredValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::statusAsString)).setter(RequestedServiceQuotaChange.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::created)).setter(RequestedServiceQuotaChange.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::lastUpdated)).setter(RequestedServiceQuotaChange.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> REQUESTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Requester").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::requester)).setter(RequestedServiceQuotaChange.setter(Builder::requester)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requester").build()}).build();
    private static final SdkField<String> QUOTA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaArn").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::quotaArn)).setter(RequestedServiceQuotaChange.setter(Builder::quotaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaArn").build()}).build();
    private static final SdkField<Boolean> GLOBAL_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GlobalQuota").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::globalQuota)).setter(RequestedServiceQuotaChange.setter(Builder::globalQuota)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalQuota").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::unit)).setter(RequestedServiceQuotaChange.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<String> QUOTA_REQUESTED_AT_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaRequestedAtLevel").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::quotaRequestedAtLevelAsString)).setter(RequestedServiceQuotaChange.setter(Builder::quotaRequestedAtLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaRequestedAtLevel").build()}).build();
    private static final SdkField<QuotaContextInfo> QUOTA_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuotaContext").getter(RequestedServiceQuotaChange.getter(RequestedServiceQuotaChange::quotaContext)).setter(RequestedServiceQuotaChange.setter(Builder::quotaContext)).constructor(QuotaContextInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CASE_ID_FIELD, SERVICE_CODE_FIELD, SERVICE_NAME_FIELD, QUOTA_CODE_FIELD, QUOTA_NAME_FIELD, DESIRED_VALUE_FIELD, STATUS_FIELD, CREATED_FIELD, LAST_UPDATED_FIELD, REQUESTER_FIELD, QUOTA_ARN_FIELD, GLOBAL_QUOTA_FIELD, UNIT_FIELD, QUOTA_REQUESTED_AT_LEVEL_FIELD, QUOTA_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("CaseId", CASE_ID_FIELD);
            this.put("ServiceCode", SERVICE_CODE_FIELD);
            this.put("ServiceName", SERVICE_NAME_FIELD);
            this.put("QuotaCode", QUOTA_CODE_FIELD);
            this.put("QuotaName", QUOTA_NAME_FIELD);
            this.put("DesiredValue", DESIRED_VALUE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Created", CREATED_FIELD);
            this.put("LastUpdated", LAST_UPDATED_FIELD);
            this.put("Requester", REQUESTER_FIELD);
            this.put("QuotaArn", QUOTA_ARN_FIELD);
            this.put("GlobalQuota", GLOBAL_QUOTA_FIELD);
            this.put("Unit", UNIT_FIELD);
            this.put("QuotaRequestedAtLevel", QUOTA_REQUESTED_AT_LEVEL_FIELD);
            this.put("QuotaContext", QUOTA_CONTEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String caseId;
    private final String serviceCode;
    private final String serviceName;
    private final String quotaCode;
    private final String quotaName;
    private final Double desiredValue;
    private final String status;
    private final Instant created;
    private final Instant lastUpdated;
    private final String requester;
    private final String quotaArn;
    private final Boolean globalQuota;
    private final String unit;
    private final String quotaRequestedAtLevel;
    private final QuotaContextInfo quotaContext;

    private RequestedServiceQuotaChange(BuilderImpl builder) {
        this.id = builder.id;
        this.caseId = builder.caseId;
        this.serviceCode = builder.serviceCode;
        this.serviceName = builder.serviceName;
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
        this.desiredValue = builder.desiredValue;
        this.status = builder.status;
        this.created = builder.created;
        this.lastUpdated = builder.lastUpdated;
        this.requester = builder.requester;
        this.quotaArn = builder.quotaArn;
        this.globalQuota = builder.globalQuota;
        this.unit = builder.unit;
        this.quotaRequestedAtLevel = builder.quotaRequestedAtLevel;
        this.quotaContext = builder.quotaContext;
    }

    public final String id() {
        return this.id;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String quotaCode() {
        return this.quotaCode;
    }

    public final String quotaName() {
        return this.quotaName;
    }

    public final Double desiredValue() {
        return this.desiredValue;
    }

    public final RequestStatus status() {
        return RequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String requester() {
        return this.requester;
    }

    public final String quotaArn() {
        return this.quotaArn;
    }

    public final Boolean globalQuota() {
        return this.globalQuota;
    }

    public final String unit() {
        return this.unit;
    }

    public final AppliedLevelEnum quotaRequestedAtLevel() {
        return AppliedLevelEnum.fromValue(this.quotaRequestedAtLevel);
    }

    public final String quotaRequestedAtLevelAsString() {
        return this.quotaRequestedAtLevel;
    }

    public final QuotaContextInfo quotaContext() {
        return this.quotaContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.requester());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaRequestedAtLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestedServiceQuotaChange)) {
            return false;
        }
        RequestedServiceQuotaChange other = (RequestedServiceQuotaChange)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.quotaName(), other.quotaName()) && Objects.equals(this.desiredValue(), other.desiredValue()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.requester(), other.requester()) && Objects.equals(this.quotaArn(), other.quotaArn()) && Objects.equals(this.globalQuota(), other.globalQuota()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.quotaRequestedAtLevelAsString(), other.quotaRequestedAtLevelAsString()) && Objects.equals(this.quotaContext(), other.quotaContext());
    }

    public final String toString() {
        return ToString.builder((String)"RequestedServiceQuotaChange").add("Id", (Object)this.id()).add("CaseId", (Object)this.caseId()).add("ServiceCode", (Object)this.serviceCode()).add("ServiceName", (Object)this.serviceName()).add("QuotaCode", (Object)this.quotaCode()).add("QuotaName", (Object)this.quotaName()).add("DesiredValue", (Object)this.desiredValue()).add("Status", (Object)this.statusAsString()).add("Created", (Object)this.created()).add("LastUpdated", (Object)this.lastUpdated()).add("Requester", (Object)this.requester()).add("QuotaArn", (Object)this.quotaArn()).add("GlobalQuota", (Object)this.globalQuota()).add("Unit", (Object)this.unit()).add("QuotaRequestedAtLevel", (Object)this.quotaRequestedAtLevelAsString()).add("QuotaContext", (Object)this.quotaContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CaseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "QuotaName": {
                return Optional.ofNullable(clazz.cast(this.quotaName()));
            }
            case "DesiredValue": {
                return Optional.ofNullable(clazz.cast(this.desiredValue()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Requester": {
                return Optional.ofNullable(clazz.cast(this.requester()));
            }
            case "QuotaArn": {
                return Optional.ofNullable(clazz.cast(this.quotaArn()));
            }
            case "GlobalQuota": {
                return Optional.ofNullable(clazz.cast(this.globalQuota()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "QuotaRequestedAtLevel": {
                return Optional.ofNullable(clazz.cast(this.quotaRequestedAtLevelAsString()));
            }
            case "QuotaContext": {
                return Optional.ofNullable(clazz.cast(this.quotaContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequestedServiceQuotaChange, T> g) {
        return obj -> g.apply((RequestedServiceQuotaChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String caseId;
        private String serviceCode;
        private String serviceName;
        private String quotaCode;
        private String quotaName;
        private Double desiredValue;
        private String status;
        private Instant created;
        private Instant lastUpdated;
        private String requester;
        private String quotaArn;
        private Boolean globalQuota;
        private String unit;
        private String quotaRequestedAtLevel;
        private QuotaContextInfo quotaContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestedServiceQuotaChange model) {
            this.id(model.id);
            this.caseId(model.caseId);
            this.serviceCode(model.serviceCode);
            this.serviceName(model.serviceName);
            this.quotaCode(model.quotaCode);
            this.quotaName(model.quotaName);
            this.desiredValue(model.desiredValue);
            this.status(model.status);
            this.created(model.created);
            this.lastUpdated(model.lastUpdated);
            this.requester(model.requester);
            this.quotaArn(model.quotaArn);
            this.globalQuota(model.globalQuota);
            this.unit(model.unit);
            this.quotaRequestedAtLevel(model.quotaRequestedAtLevel);
            this.quotaContext(model.quotaContext);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getQuotaName() {
            return this.quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final Double getDesiredValue() {
            return this.desiredValue;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        @Override
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getRequester() {
            return this.requester;
        }

        public final void setRequester(String requester) {
            this.requester = requester;
        }

        @Override
        public final Builder requester(String requester) {
            this.requester = requester;
            return this;
        }

        public final String getQuotaArn() {
            return this.quotaArn;
        }

        public final void setQuotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
        }

        @Override
        public final Builder quotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
            return this;
        }

        public final Boolean getGlobalQuota() {
            return this.globalQuota;
        }

        public final void setGlobalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
        }

        @Override
        public final Builder globalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final String getQuotaRequestedAtLevel() {
            return this.quotaRequestedAtLevel;
        }

        public final void setQuotaRequestedAtLevel(String quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel = quotaRequestedAtLevel;
        }

        @Override
        public final Builder quotaRequestedAtLevel(String quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel = quotaRequestedAtLevel;
            return this;
        }

        @Override
        public final Builder quotaRequestedAtLevel(AppliedLevelEnum quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel(quotaRequestedAtLevel == null ? null : quotaRequestedAtLevel.toString());
            return this;
        }

        public final QuotaContextInfo.Builder getQuotaContext() {
            return this.quotaContext != null ? this.quotaContext.toBuilder() : null;
        }

        public final void setQuotaContext(QuotaContextInfo.BuilderImpl quotaContext) {
            this.quotaContext = quotaContext != null ? quotaContext.build() : null;
        }

        @Override
        public final Builder quotaContext(QuotaContextInfo quotaContext) {
            this.quotaContext = quotaContext;
            return this;
        }

        public RequestedServiceQuotaChange build() {
            return new RequestedServiceQuotaChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestedServiceQuotaChange> {
        public Builder id(String var1);

        public Builder caseId(String var1);

        public Builder serviceCode(String var1);

        public Builder serviceName(String var1);

        public Builder quotaCode(String var1);

        public Builder quotaName(String var1);

        public Builder desiredValue(Double var1);

        public Builder status(String var1);

        public Builder status(RequestStatus var1);

        public Builder created(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder requester(String var1);

        public Builder quotaArn(String var1);

        public Builder globalQuota(Boolean var1);

        public Builder unit(String var1);

        public Builder quotaRequestedAtLevel(String var1);

        public Builder quotaRequestedAtLevel(AppliedLevelEnum var1);

        public Builder quotaContext(QuotaContextInfo var1);

        default public Builder quotaContext(Consumer<QuotaContextInfo.Builder> quotaContext) {
            return this.quotaContext((QuotaContextInfo)((QuotaContextInfo.Builder)QuotaContextInfo.builder().applyMutation(quotaContext)).build());
        }
    }
}

