/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuota;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaListDefinitionCopier;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceQuotasResponse
extends ServiceQuotasResponse
implements ToCopyableBuilder<Builder, ListServiceQuotasResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceQuotasResponse.getter(ListServiceQuotasResponse::nextToken)).setter(ListServiceQuotasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServiceQuota>> QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Quotas").getter(ListServiceQuotasResponse.getter(ListServiceQuotasResponse::quotas)).setter(ListServiceQuotasResponse.setter(Builder::quotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUOTAS_FIELD));
    private final String nextToken;
    private final List<ServiceQuota> quotas;

    private ListServiceQuotasResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quotas = builder.quotas;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasQuotas() {
        return this.quotas != null && !(this.quotas instanceof SdkAutoConstructList);
    }

    public List<ServiceQuota> quotas() {
        return this.quotas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuotas() ? this.quotas() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotasResponse)) {
            return false;
        }
        ListServiceQuotasResponse other = (ListServiceQuotasResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasQuotas() == other.hasQuotas() && Objects.equals(this.quotas(), other.quotas());
    }

    public String toString() {
        return ToString.builder((String)"ListServiceQuotasResponse").add("NextToken", (Object)this.nextToken()).add("Quotas", this.hasQuotas() ? this.quotas() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Quotas": {
                return Optional.ofNullable(clazz.cast(this.quotas()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceQuotasResponse, T> g) {
        return obj -> g.apply((ListServiceQuotasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceQuota> quotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceQuotasResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.quotas(model.quotas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ServiceQuota.Builder> getQuotas() {
            if (this.quotas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.quotas != null ? (Collection)this.quotas.stream().map(ServiceQuota::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder quotas(Collection<ServiceQuota> quotas) {
            this.quotas = ServiceQuotaListDefinitionCopier.copy(quotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(ServiceQuota ... quotas) {
            this.quotas(Arrays.asList(quotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(Consumer<ServiceQuota.Builder> ... quotas) {
            this.quotas(Stream.of(quotas).map(c -> (ServiceQuota)((ServiceQuota.Builder)ServiceQuota.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQuotas(Collection<ServiceQuota.BuilderImpl> quotas) {
            this.quotas = ServiceQuotaListDefinitionCopier.copyFromBuilder(quotas);
        }

        @Override
        public ListServiceQuotasResponse build() {
            return new ListServiceQuotasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceQuotasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceQuotasResponse> {
        public Builder nextToken(String var1);

        public Builder quotas(Collection<ServiceQuota> var1);

        public Builder quotas(ServiceQuota ... var1);

        public Builder quotas(Consumer<ServiceQuota.Builder> ... var1);
    }
}

