/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.model.AccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.AwsServiceAccessNotEnabledException;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DependencyAccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.IllegalArgumentException;
import software.amazon.awssdk.services.servicequotas.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.servicequotas.model.InvalidResourceStateException;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.servicequotas.model.NoSuchResourceException;
import software.amazon.awssdk.services.servicequotas.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.QuotaExceededException;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.servicequotas.model.ServiceException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaTemplateNotInUseException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.TemplatesNotAvailableInRegionException;
import software.amazon.awssdk.services.servicequotas.model.TooManyRequestsException;
import software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher;
import software.amazon.awssdk.services.servicequotas.transform.AssociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DisassociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAssociationForServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAwsDefaultServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetRequestedServiceQuotaChangeRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListAwsDefaultServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.RequestServiceQuotaIncreaseRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultServiceQuotasAsyncClient
implements ServiceQuotasAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceQuotasAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceQuotasAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "servicequotas";
    }

    @Override
    public CompletableFuture<AssociateServiceQuotaTemplateResponse> associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateServiceQuotaTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateServiceQuotaTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateServiceQuotaTemplate").withMarshaller((Marshaller)new AssociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)associateServiceQuotaTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceQuotaIncreaseRequestFromTemplateResponse> deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceQuotaIncreaseRequestFromTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceQuotaIncreaseRequestFromTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceQuotaIncreaseRequestFromTemplate").withMarshaller((Marshaller)new DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteServiceQuotaIncreaseRequestFromTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateServiceQuotaTemplateResponse> disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateServiceQuotaTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateServiceQuotaTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateServiceQuotaTemplate").withMarshaller((Marshaller)new DisassociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disassociateServiceQuotaTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAwsDefaultServiceQuotaResponse> getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAWSDefaultServiceQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAwsDefaultServiceQuotaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAWSDefaultServiceQuota").withMarshaller((Marshaller)new GetAwsDefaultServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getAwsDefaultServiceQuotaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAwsDefaultServiceQuotaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAwsDefaultServiceQuotaRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAssociationForServiceQuotaTemplateResponse> getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssociationForServiceQuotaTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssociationForServiceQuotaTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssociationForServiceQuotaTemplate").withMarshaller((Marshaller)new GetAssociationForServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getAssociationForServiceQuotaTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAssociationForServiceQuotaTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAssociationForServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRequestedServiceQuotaChangeResponse> getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRequestedServiceQuotaChange");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRequestedServiceQuotaChangeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRequestedServiceQuotaChange").withMarshaller((Marshaller)new GetRequestedServiceQuotaChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getRequestedServiceQuotaChangeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRequestedServiceQuotaChangeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRequestedServiceQuotaChangeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceQuotaResponse> getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuota").withMarshaller((Marshaller)new GetServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getServiceQuotaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getServiceQuotaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, getServiceQuotaRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceQuotaIncreaseRequestFromTemplateResponse> getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuotaIncreaseRequestFromTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaIncreaseRequestFromTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuotaIncreaseRequestFromTemplate").withMarshaller((Marshaller)new GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getServiceQuotaIncreaseRequestFromTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, getServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAwsDefaultServiceQuotasResponse> listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAWSDefaultServiceQuotas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsDefaultServiceQuotasResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSDefaultServiceQuotas").withMarshaller((Marshaller)new ListAwsDefaultServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listAwsDefaultServiceQuotasRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAwsDefaultServiceQuotasRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAwsDefaultServiceQuotasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAWSDefaultServiceQuotasPublisher listAWSDefaultServiceQuotasPaginator(ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        return new ListAWSDefaultServiceQuotasPublisher(this, this.applyPaginatorUserAgent(listAwsDefaultServiceQuotasRequest));
    }

    @Override
    public CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistory").withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRequestedServiceQuotaChangeHistoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRequestedServiceQuotaChangeHistoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistoryByQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryByQuotaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistoryByQuota").withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryByQuotaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRequestedServiceQuotaChangeHistoryByQuotaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRequestedServiceQuotaChangeHistoryByQuotaRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRequestedServiceQuotaChangeHistoryByQuotaPublisher listRequestedServiceQuotaChangeHistoryByQuotaPaginator(ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        return new ListRequestedServiceQuotaChangeHistoryByQuotaPublisher(this, this.applyPaginatorUserAgent(listRequestedServiceQuotaChangeHistoryByQuotaRequest));
    }

    @Override
    public ListRequestedServiceQuotaChangeHistoryPublisher listRequestedServiceQuotaChangeHistoryPaginator(ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        return new ListRequestedServiceQuotaChangeHistoryPublisher(this, this.applyPaginatorUserAgent(listRequestedServiceQuotaChangeHistoryRequest));
    }

    @Override
    public CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotaIncreaseRequestsInTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotaIncreaseRequestsInTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotaIncreaseRequestsInTemplate").withMarshaller((Marshaller)new ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listServiceQuotaIncreaseRequestsInTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listServiceQuotaIncreaseRequestsInTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, listServiceQuotaIncreaseRequestsInTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListServiceQuotaIncreaseRequestsInTemplatePublisher listServiceQuotaIncreaseRequestsInTemplatePaginator(ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        return new ListServiceQuotaIncreaseRequestsInTemplatePublisher(this, this.applyPaginatorUserAgent(listServiceQuotaIncreaseRequestsInTemplateRequest));
    }

    @Override
    public CompletableFuture<ListServiceQuotasResponse> listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotasResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotas").withMarshaller((Marshaller)new ListServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listServiceQuotasRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listServiceQuotasRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, listServiceQuotasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListServiceQuotasPublisher listServiceQuotasPaginator(ListServiceQuotasRequest listServiceQuotasRequest) {
        return new ListServiceQuotasPublisher(this, this.applyPaginatorUserAgent(listServiceQuotasRequest));
    }

    @Override
    public CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listServicesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listServicesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListServicesPublisher listServicesPaginator(ListServicesRequest listServicesRequest) {
        return new ListServicesPublisher(this, this.applyPaginatorUserAgent(listServicesRequest));
    }

    @Override
    public CompletableFuture<PutServiceQuotaIncreaseRequestIntoTemplateResponse> putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutServiceQuotaIncreaseRequestIntoTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutServiceQuotaIncreaseRequestIntoTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutServiceQuotaIncreaseRequestIntoTemplate").withMarshaller((Marshaller)new PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)putServiceQuotaIncreaseRequestIntoTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putServiceQuotaIncreaseRequestIntoTemplateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, putServiceQuotaIncreaseRequestIntoTemplateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RequestServiceQuotaIncreaseResponse> requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestServiceQuotaIncrease");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestServiceQuotaIncreaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestServiceQuotaIncrease").withMarshaller((Marshaller)new RequestServiceQuotaIncreaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)requestServiceQuotaIncreaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = requestServiceQuotaIncreaseRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(this.clientConfiguration, requestServiceQuotaIncreaseRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceQuotasException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").exceptionBuilderSupplier(InvalidResourceStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalArgumentException").exceptionBuilderSupplier(IllegalArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResourceException").exceptionBuilderSupplier(NoSuchResourceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceededException").exceptionBuilderSupplier(QuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ServiceQuotasRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.55").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ServiceQuotasRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

