/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.DnsProperties;
import software.amazon.awssdk.services.servicediscovery.model.HttpProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamespaceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamespaceProperties> {
    private static final SdkField<DnsProperties> DNS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsProperties").getter(NamespaceProperties.getter(NamespaceProperties::dnsProperties)).setter(NamespaceProperties.setter(Builder::dnsProperties)).constructor(DnsProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsProperties").build()}).build();
    private static final SdkField<HttpProperties> HTTP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpProperties").getter(NamespaceProperties.getter(NamespaceProperties::httpProperties)).setter(NamespaceProperties.setter(Builder::httpProperties)).constructor(HttpProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_PROPERTIES_FIELD, HTTP_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NamespaceProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DnsProperties dnsProperties;
    private final HttpProperties httpProperties;

    private NamespaceProperties(BuilderImpl builder) {
        this.dnsProperties = builder.dnsProperties;
        this.httpProperties = builder.httpProperties;
    }

    public final DnsProperties dnsProperties() {
        return this.dnsProperties;
    }

    public final HttpProperties httpProperties() {
        return this.httpProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceProperties)) {
            return false;
        }
        NamespaceProperties other = (NamespaceProperties)obj;
        return Objects.equals(this.dnsProperties(), other.dnsProperties()) && Objects.equals(this.httpProperties(), other.httpProperties());
    }

    public final String toString() {
        return ToString.builder((String)"NamespaceProperties").add("DnsProperties", (Object)this.dnsProperties()).add("HttpProperties", (Object)this.httpProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsProperties": {
                return Optional.ofNullable(clazz.cast(this.dnsProperties()));
            }
            case "HttpProperties": {
                return Optional.ofNullable(clazz.cast(this.httpProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DnsProperties", DNS_PROPERTIES_FIELD);
        map.put("HttpProperties", HTTP_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamespaceProperties, T> g) {
        return obj -> g.apply((NamespaceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DnsProperties dnsProperties;
        private HttpProperties httpProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceProperties model) {
            this.dnsProperties(model.dnsProperties);
            this.httpProperties(model.httpProperties);
        }

        public final DnsProperties.Builder getDnsProperties() {
            return this.dnsProperties != null ? this.dnsProperties.toBuilder() : null;
        }

        public final void setDnsProperties(DnsProperties.BuilderImpl dnsProperties) {
            this.dnsProperties = dnsProperties != null ? dnsProperties.build() : null;
        }

        @Override
        public final Builder dnsProperties(DnsProperties dnsProperties) {
            this.dnsProperties = dnsProperties;
            return this;
        }

        public final HttpProperties.Builder getHttpProperties() {
            return this.httpProperties != null ? this.httpProperties.toBuilder() : null;
        }

        public final void setHttpProperties(HttpProperties.BuilderImpl httpProperties) {
            this.httpProperties = httpProperties != null ? httpProperties.build() : null;
        }

        @Override
        public final Builder httpProperties(HttpProperties httpProperties) {
            this.httpProperties = httpProperties;
            return this;
        }

        public NamespaceProperties build() {
            return new NamespaceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamespaceProperties> {
        public Builder dnsProperties(DnsProperties var1);

        default public Builder dnsProperties(Consumer<DnsProperties.Builder> dnsProperties) {
            return this.dnsProperties((DnsProperties)((DnsProperties.Builder)DnsProperties.builder().applyMutation(dnsProperties)).build());
        }

        public Builder httpProperties(HttpProperties var1);

        default public Builder httpProperties(Consumer<HttpProperties.Builder> httpProperties) {
            return this.httpProperties((HttpProperties)((HttpProperties.Builder)HttpProperties.builder().applyMutation(httpProperties)).build());
        }
    }
}

