/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheckConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheckConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(HealthCheckConfig.getter(HealthCheckConfig::typeAsString)).setter(HealthCheckConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> RESOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePath").getter(HealthCheckConfig.getter(HealthCheckConfig::resourcePath)).setter(HealthCheckConfig.setter(Builder::resourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePath").build()}).build();
    private static final SdkField<Integer> FAILURE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureThreshold").getter(HealthCheckConfig.getter(HealthCheckConfig::failureThreshold)).setter(HealthCheckConfig.setter(Builder::failureThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RESOURCE_PATH_FIELD, FAILURE_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("ResourcePath", RESOURCE_PATH_FIELD);
            this.put("FailureThreshold", FAILURE_THRESHOLD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String resourcePath;
    private final Integer failureThreshold;

    private HealthCheckConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.failureThreshold = builder.failureThreshold;
    }

    public final HealthCheckType type() {
        return HealthCheckType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String resourcePath() {
        return this.resourcePath;
    }

    public final Integer failureThreshold() {
        return this.failureThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resourcePath(), other.resourcePath()) && Objects.equals(this.failureThreshold(), other.failureThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheckConfig").add("Type", (Object)this.typeAsString()).add("ResourcePath", (Object)this.resourcePath()).add("FailureThreshold", (Object)this.failureThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ResourcePath": {
                return Optional.ofNullable(clazz.cast(this.resourcePath()));
            }
            case "FailureThreshold": {
                return Optional.ofNullable(clazz.cast(this.failureThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfig, T> g) {
        return obj -> g.apply((HealthCheckConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String resourcePath;
        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            this.type(model.type);
            this.resourcePath(model.resourcePath);
            this.failureThreshold(model.failureThreshold);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HealthCheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResourcePath() {
            return this.resourcePath;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheckConfig> {
        public Builder type(String var1);

        public Builder type(HealthCheckType var1);

        public Builder resourcePath(String var1);

        public Builder failureThreshold(Integer var1);
    }
}

