/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NamespaceType {
    DNS_PUBLIC("DNS_PUBLIC"),
    DNS_PRIVATE("DNS_PRIVATE"),
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NamespaceType> VALUE_MAP;
    private final String value;

    private NamespaceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NamespaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NamespaceType> knownValues() {
        EnumSet<NamespaceType> knownValues = EnumSet.allOf(NamespaceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NamespaceType.class, NamespaceType::toString);
    }
}

