/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePublicDnsNamespaceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, CreatePublicDnsNamespaceRequest> {
    private final String name;
    private final String creatorRequestId;
    private final String description;

    private CreatePublicDnsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
    }

    public String name() {
        return this.name;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicDnsNamespaceRequest)) {
            return false;
        }
        CreatePublicDnsNamespaceRequest other = (CreatePublicDnsNamespaceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"CreatePublicDnsNamespaceRequest").add("Name", (Object)this.name()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "CreatorRequestId": {
                return Optional.of(clazz.cast(this.creatorRequestId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String creatorRequestId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicDnsNamespaceRequest model) {
            this.name(model.name);
            this.creatorRequestId(model.creatorRequestId);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePublicDnsNamespaceRequest build() {
            return new CreatePublicDnsNamespaceRequest(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    CopyableBuilder<Builder, CreatePublicDnsNamespaceRequest> {
        public Builder name(String var1);

        public Builder creatorRequestId(String var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

