/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NamespacePropertiesMarshaller {
    private static final MarshallingInfo<StructuredPojo> DNSPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsProperties").isBinary(false).build();
    private static final NamespacePropertiesMarshaller INSTANCE = new NamespacePropertiesMarshaller();

    private NamespacePropertiesMarshaller() {
    }

    public static NamespacePropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NamespaceProperties namespaceProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)namespaceProperties, (String)"namespaceProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)namespaceProperties.dnsProperties(), DNSPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

