/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceSummariesListCopier;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceSummary;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNamespacesResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, ListNamespacesResponse> {
    private final List<NamespaceSummary> namespaces;
    private final String nextToken;

    private ListNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.namespaces = builder.namespaces;
        this.nextToken = builder.nextToken;
    }

    public List<NamespaceSummary> namespaces() {
        return this.namespaces;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResponse)) {
            return false;
        }
        ListNamespacesResponse other = (ListNamespacesResponse)((Object)obj);
        return Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNamespacesResponse").add("Namespaces", this.namespaces()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<NamespaceSummary> namespaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesResponse model) {
            super(model);
            this.namespaces(model.namespaces);
            this.nextToken(model.nextToken);
        }

        public final Collection<NamespaceSummary.Builder> getNamespaces() {
            return this.namespaces != null ? (Collection)this.namespaces.stream().map(NamespaceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder namespaces(Collection<NamespaceSummary> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(NamespaceSummary ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(Consumer<NamespaceSummary.Builder> ... namespaces) {
            this.namespaces(Stream.of(namespaces).map(c -> (NamespaceSummary)((NamespaceSummary.Builder)NamespaceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNamespaces(Collection<NamespaceSummary.BuilderImpl> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copyFromBuilder(namespaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNamespacesResponse build() {
            return new ListNamespacesResponse(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    CopyableBuilder<Builder, ListNamespacesResponse> {
        public Builder namespaces(Collection<NamespaceSummary> var1);

        public Builder namespaces(NamespaceSummary ... var1);

        public Builder namespaces(Consumer<NamespaceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

