/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HealthCheckConfigMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourcePath").isBinary(false).build();
    private static final MarshallingInfo<Integer> FAILURETHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureThreshold").isBinary(false).build();
    private static final HealthCheckConfigMarshaller INSTANCE = new HealthCheckConfigMarshaller();

    private HealthCheckConfigMarshaller() {
    }

    public static HealthCheckConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HealthCheckConfig healthCheckConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)healthCheckConfig, (String)"healthCheckConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)healthCheckConfig.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)healthCheckConfig.resourcePath(), RESOURCEPATH_BINDING);
            protocolMarshaller.marshall((Object)healthCheckConfig.failureThreshold(), FAILURETHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

