/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> SERVICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final GetInstanceRequestModelMarshaller INSTANCE = new GetInstanceRequestModelMarshaller();

    private GetInstanceRequestModelMarshaller() {
    }

    public static GetInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetInstanceRequest getInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getInstanceRequest), (String)"getInstanceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getInstanceRequest.serviceId(), SERVICEID_BINDING);
            protocolMarshaller.marshall((Object)getInstanceRequest.instanceId(), INSTANCEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

