/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;

public class ListInstancesPublisher
implements SdkPublisher<ListInstancesResponse> {
    private final ServiceDiscoveryAsyncClient client;
    private final ListInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstancesPublisher(ServiceDiscoveryAsyncClient client, ListInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstancesPublisher(ServiceDiscoveryAsyncClient client, ListInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListInstancesPublisher resume(ListInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstancesPublisher(this.client, (ListInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInstancesResponseFetcher
    implements AsyncPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListInstancesResponse> nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesPublisher.this.client.listInstances(ListInstancesPublisher.this.firstRequest);
            }
            return ListInstancesPublisher.this.client.listInstances((ListInstancesRequest)((Object)ListInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

