/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicediscovery.model.ServiceChange;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateServiceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, UpdateServiceRequest> {
    private final String id;
    private final ServiceChange service;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.service = builder.service;
    }

    public String id() {
        return this.id;
    }

    public ServiceChange service() {
        return this.service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.service(), other.service());
    }

    public String toString() {
        return ToString.builder((String)"UpdateServiceRequest").add("Id", (Object)this.id()).add("Service", (Object)this.service()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Service": {
                return Optional.of(clazz.cast(this.service()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String id;
        private ServiceChange service;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            this.id(model.id);
            this.service(model.service);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ServiceChange.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        @Override
        public final Builder service(ServiceChange service) {
            this.service = service;
            return this;
        }

        public final void setService(ServiceChange.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    CopyableBuilder<Builder, UpdateServiceRequest> {
        public Builder id(String var1);

        public Builder service(ServiceChange var1);

        default public Builder service(Consumer<ServiceChange.Builder> service) {
            return this.service((ServiceChange)((ServiceChange.Builder)ServiceChange.builder().apply(service)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

