/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.servicediscovery.model.InstanceSummary;
import software.amazon.awssdk.services.servicediscovery.model.InstanceSummaryListCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstancesResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, ListInstancesResponse> {
    private final List<InstanceSummary> instances;
    private final String nextToken;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceSummary> instances() {
        return this.instances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInstancesResponse").add("Instances", this.instances()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<InstanceSummary> instances;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            this.instances(model.instances);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceSummary.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(InstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<InstanceSummary> instances) {
            this.instances = InstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceSummary ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceSummary.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (InstanceSummary)((InstanceSummary.Builder)InstanceSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<InstanceSummary.BuilderImpl> instances) {
            this.instances = InstanceSummaryListCopier.copyFromBuilder(instances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    CopyableBuilder<Builder, ListInstancesResponse> {
        public Builder instances(Collection<InstanceSummary> var1);

        public Builder instances(InstanceSummary ... var1);

        public Builder instances(Consumer<InstanceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

